
*****************************************************************************************************************************
***     ANALYSIS:  Capturing Multiple Perspectives in a Multi-actor Survey: 											  ***
***				   The Impact of Parental Presence in Child Interviews on Reporting Discrepancies 						  ***	
***		DATA:      Pairfam waves 1 to 9, Release 9.1 						  			  		  		  			      ***
***																														  ***
*** 	CONTENT: - Response and coverage rates in parenting and child survey (Section 3.1, Footnote 6)     			      ***
***				 - Data preparation:														  		  	  			      ***
***				 		1) Including variable 'First child interview in household' in child data sets (child`wave'r.dta)  ***
***						2) Including variable 'Number of child interviews' in child data sets (child`wave'r.dta)   	      ***
***						3) Merge 'autonomy as parenting goal' from anchor waves 2-5 to waves 6-9 (anchor`wave'r.dta) 	  ***
*****************************************************************************************************************************

clear all
set maxvar 15000
set more off
set varabbrev off

global path1 `""datapath""'  
global path2 `""outputpath""'  
global path3 `""syntaxpath""'  


*** Response and coverage rates in parenting and child surveys (Footnote 6, Section 3.1)

** Child survey
foreach wave in 6 7 8 9{
	cd $path1	
	use anchor`wave', clear							
	keep id cid* wave capikidk* ccs1k*
	reshape long capikidk cid ccs1k, i(id) j(j)
	keep if capikidk==1
	
	merge 1:1 cid using child`wave', keepusing (id cid wave) 
	gen nr_child=0
	replace nr_child=1 if _merge==1
	drop _merge
	save temp`wave'.dta, replace	
}

use temp6, clear				
for num 7/9: append using tempX, nolabel	
tab nr_child, m								// Averaged over waves 6-9, the child survey covers 71.4 of all eligible children
tab wave nr_child, row

tab nr_child if inlist(ccs1k,1,2),m 		// Averaged over waves 6-9, children's response rate conditional on parent consent amounts to 95.5%
tab wave nr_child if inlist(ccs1k,1,2), row

for num 6/9: erase tempX.dta


** Parenting survey (anchor parent)
foreach wave in 6 7 8 9{
	cd $path1	
	use parenting`wave', clear
	drop if dropoffvers==2					// restrict sample to anchor reports on parenting
	save parenting`wave'r, replace
	
	use anchor`wave', clear							
	keep id cid* wave capikidk* cpas1 cpas3
	reshape long capikidk cid, i(id) j(j)
	keep if capikidk==1
	
	merge 1:m cid using parenting`wave'r, keepusing (id cid wave dropoffvers) 
	gen nr_parenting=0
	replace nr_parenting=1 if _merge==1
	drop _merge
	save temp`wave'.dta, replace	
}

use temp6, clear				
for num 7 8 9: append using tempX, nolabel	
tab nr_parenting, m							// Averaged over waves 6-9, the (anchor) parenting survey covers 73.7 of all eligible children
tab wave nr_parenting, row					

tab nr_parenting if cpas1==1, m				// Averaged over waves 6-9, 80.1% of eligible anchor parents accepted the parenting survey
tab wave nr_parenting if cpas1==1, row

for num 6/9: erase tempX.dta
	
	
** Parenting survey (other parent)
foreach wave in 6 7 8 9{
	cd $path1	
	use parenting`wave', clear
	drop if dropoffvers==1					// restrict sample to anchor reports on parenting
	save parentingtemp`wave', replace
	
	use anchor`wave', clear							
	keep id cid* wave capikidk* cpas1 cpas3
	reshape long capikidk cid, i(id) j(j)
	keep if capikidk==1
	
	merge 1:m cid using parentingtemp`wave', keepusing (id cid wave dropoffvers) 
	gen nr_parenting=0
	replace nr_parenting=1 if _merge==1
	drop _merge
	save temp`wave'.dta, replace	
}

use temp6, clear				
for num 7/9: append using tempX, nolabel	
tab nr_parenting, m							// Averaged over waves 6-9, the parenting survey (other parent) covers 47.0 of all eligible children
tab wave nr_parenting, row					

tab nr_parenting if cpas1==1, m				// Averaged over waves 6-9, 48.4% of eligible anchor parents accepted the parenting survey
tab wave nr_parenting if cpas1==1, row

for num 6/9: erase tempX.dta
for num 6/9: erase parentingtempX.dta

	
	
*** Including Information on children's interview experience (per child and per anchor houshold from wave two onwards) in child data sets
cd $path1	
use child2, clear

quietly: for num 3/9: append using childX.dta, force
sort id cid wave
tab wave, m

** Number interviews per child waves 2-9
bysort cid (wave): gen pynrc = _n             
bysort id (wave): gen pynr = _n            

gen nbpart=pynrc
label var nbpart "Number of Interviews (Child)"

tab nbpart, m
tab wave nbpart, m


** Dummy variable indicating previous child interviews in household
gen help=.
replace help=wave if pynrc==1

// flag: multiple children entering the survey in the same wave: "no prev. household interview" for each child
gen help2=0
bysort id (wave): replace help2=1 if pynrc==1 & help==help[_n-1] & help!=. & help[_n-1]!=.			

gen firstinthh=pynr
replace firstinthh=1 if firstinthh==1 | help2==1
replace firstinthh=0 if firstinthh>1
label var firstinthh "First child interviews in household"

drop help*
drop py* 

save child_temp, replace


** Save data sets child`wave'r.dta including information on interview experience
foreach x in 6 7 8 9{
	use child_temp, clear
	keep if wave==`x'
	count
	save child`x'r, replace
}

erase child_temp.dta



*** Merge informations on 'autonomy as parenting goal' from anchor waves 2-5 to waves 6-9

* Information on crn19i* was only collected in wave 2 and not for demodiff sample; in the following waves only for respondents 
* who so far had no children in their household but have biological/adoptive/step children in their household in the current wave, 
* or first-time respondents with biological/adoptive/step children in their household

** Include information on anchor's child rearing goals from wave 2 in anchor data sets 6-9
foreach wave in 6 7 8 9 {
	use id demodiff crn19i* using anchor2, clear
	ren crn19i* w2_crn19i*
	merge 1:1 id using anchor`wave'
	drop if _merge==1
	drop _merge
	save anchor`wave'r, replace				// Save data sets anchor`wave'r.dta 
}

** Include information on anchor's child rearing goals from wave 3 in anchor data sets 6-9
foreach wave in 6 7 8 9{
	use id demodiff crn19i* using anchor3, clear
	ren crn19i* w3_crn19i*
	merge 1:1 id using anchor`wave'r
	drop if _merge==1
	drop _merge
	save anchor`wave'r, replace			   // Save data sets anchor`wave'r.dta 
}

** Include information on anchor's child rearing goals from wave 4 in anchor data sets 6-9
foreach wave in 6 7 8 9{
	use id demodiff crn19i* using anchor4, clear
	ren crn19i* w4_crn19i*
	merge 1:1 id using anchor`wave'r
	drop if _merge==1
	drop _merge
	save anchor`wave'r, replace			   // Save data sets anchor`wave'r.dta 
}

** Include information on anchor's child rearing goals from wave 5 in anchor data sets 6-9
foreach wave in 6 7 8 9{
	use id demodiff crn19i* using anchor5, clear
	ren crn19i* w5_crn19i*
	merge 1:1 id using anchor`wave'r
	drop if _merge==1
	drop _merge
	save anchor`wave'r, replace			  // Save data sets anchor`wave'r.dta 
}


